<?php
require_once '../config.php';

if(!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Please login first']);
    exit();
}

if(!isActiveUser()) {
    echo json_encode(['success' => false, 'message' => 'Please activate your account first']);
    exit();
}

if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['product_id'])) {
    $product_id = (int)$_POST['product_id'];
    
    // Check if product exists and is active
    $stmt = $conn->prepare("SELECT id, name, sale_price FROM products WHERE id = ? AND status = 'active'");
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows == 0) {
        echo json_encode(['success' => false, 'message' => 'Product not found']);
        exit();
    }
    
    // Initialize cart session if not exists
    if(!isset($_SESSION['cart'])) {
        $_SESSION['cart'] = [];
    }
    
    // Add product to cart or update quantity
    if(isset($_SESSION['cart'][$product_id])) {
        $_SESSION['cart'][$product_id]['quantity'] += 1;
    } else {
        $_SESSION['cart'][$product_id] = [
            'quantity' => 1,
            'added_at' => time()
        ];
    }
    
    // Get cart count
    $cart_count = count($_SESSION['cart']);
    
    echo json_encode([
        'success' => true,
        'message' => 'Product added to cart',
        'cart_count' => $cart_count
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request']);
}
?>